package com.example.sefinsa_app.utilities;

import static androidx.constraintlayout.helper.widget.MotionEffect.TAG;
import static com.example.sefinsa_app.utilities.PrinterCommands.ESC_ALIGN_CENTER;

import android.Manifest;
import android.annotation.SuppressLint;
import android.bluetooth.BluetoothAdapter;
import android.bluetooth.BluetoothDevice;
import android.bluetooth.BluetoothHeadset;
import android.bluetooth.BluetoothSocket;
import android.content.BroadcastReceiver;
import android.content.Context;
import android.content.Intent;
import android.content.SharedPreferences;
import android.graphics.Bitmap;
import android.graphics.BitmapFactory;
import android.graphics.Canvas;
import android.graphics.Color;
import android.graphics.ColorMatrix;
import android.graphics.ColorMatrixColorFilter;
import android.graphics.Paint;
import android.graphics.drawable.BitmapDrawable;
import android.graphics.drawable.Drawable;
import android.os.Build;
import android.os.Handler;
import android.os.Looper;
import android.os.Message;
import android.util.Base64;
import android.util.Log;
import android.widget.ArrayAdapter;
import android.widget.Toast;

import androidx.annotation.RequiresApi;
import androidx.core.app.ActivityCompat;
import androidx.print.PrintHelper;

import com.example.sefinsa_app.R;
import com.example.sefinsa_app.controllers.ClienteController;
import com.example.sefinsa_app.controllers.ColocadoraController;
import com.example.sefinsa_app.controllers.PoblacionController;
import com.example.sefinsa_app.controllers.RutaController;
import com.example.sefinsa_app.models.Articulo;
import com.example.sefinsa_app.models.Folio;
import com.example.sefinsa_app.models.Pago;
import com.example.sefinsa_app.models.PagosHechos;
import com.example.sefinsa_app.models.Poblacion;
import com.example.sefinsa_app.models.Prestamo;
import com.example.sefinsa_app.models.RMD;
import com.example.sefinsa_app.models.ReporteGeneral;
import com.google.gson.Gson;
import com.itextpdf.io.image.ImageData;
import com.itextpdf.io.image.ImageDataFactory;
import com.itextpdf.kernel.pdf.PdfDocument;
import com.itextpdf.kernel.pdf.PdfWriter;
import com.itextpdf.layout.Document;
import com.itextpdf.layout.element.Image;
import com.itextpdf.layout.element.Paragraph;

import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.lang.reflect.Method;
import java.nio.charset.StandardCharsets;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.time.LocalDate;
import java.time.format.DateTimeFormatter;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.BitSet;
import java.util.Date;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.UUID;
import java.util.stream.Collectors;

import kotlin.reflect.KFunction;

public class BluetoothUtils {

    public static BluetoothAdapter mBTAdapter = BluetoothAdapter.getDefaultAdapter();
    public static Set<BluetoothDevice> mPairedDevices;
    public static ArrayAdapter<String> mBTArrayAdapter ;
    public static Context context;
    private static final UUID BT_MODULE_UUID = UUID.fromString("00001101-0000-1000-8000-00805F9B34FB"); // "random" unique identifier
    public static BluetoothDevice mmDevice;

    public static Handler mHandler; // Our main handler that will receive callback notifications
    public static ConnectedThread mConnectedThread; // bluetooth background worker thread to send and receive data
    public static BluetoothSocket mBTSocket = null; // bi-directional client-to-client data path
    public static BroadcastReceiver BTReceiver;
    public static SharedPreferences sesion;

    @SuppressLint("MissingPermission")
    public static BluetoothSocket createBluetoothSocket(BluetoothDevice device) throws IOException {
        try {
            final Method m = device.getClass().getMethod("createInsecureRfcommSocketToServiceRecord", UUID.class);
            return (BluetoothSocket) m.invoke(device, BT_MODULE_UUID);
        } catch (Exception e) {
            Log.e("createBluetoothSocket", "Could not create Insecure RFComm Connection",e);
        }
        return device.createRfcommSocketToServiceRecord(BT_MODULE_UUID);
    }

    @SuppressLint("MissingPermission")
    public static void listPairedDevices(String deviceId){
        mPairedDevices = mBTAdapter.getBondedDevices();
        if(mBTAdapter.isEnabled()) {
            // put it's one to the adapter
            for (BluetoothDevice device : mPairedDevices){
                Log.d(TAG, "listPairedDevices: " + mPairedDevices.toArray()[0]);
                Log.d(TAG, "listPairedDevices: " + deviceId);
                mmDevice = device;
                if (device.getName().equals(deviceId)) {
                    mmDevice = device;
                    //mBTArrayAdapter.add(device.getName() + "\n" + device.getAddress());
                    break;
                }
            }

            Toast.makeText(context, "Emparejando dispositivo", Toast.LENGTH_SHORT).show();
        }
        else {
            Toast.makeText(context, "Bluetooth apagado", Toast.LENGTH_SHORT).show();
        }

        Log.d("DEVICE", BluetoothUtils.mmDevice.getName());
    }

    public static void initThread(){

        mHandler = new Handler(Looper.getMainLooper()){
            @SuppressLint("MissingPermission")
            @Override
            public void handleMessage(Message msg){
                if(msg.what == 2){
                    String readMessage = null;
                    readMessage = new String((byte[]) msg.obj, StandardCharsets.UTF_8);
                    Log.d("readBuffer", readMessage);
                }

                if(msg.what == 3){
                    char[] sConnected;
                    if(msg.arg1 == 1){
                        Log.d("BT STATUS", "Connect");
                        Toast.makeText(context, "Conectado a " + mmDevice.getName(), Toast.LENGTH_SHORT).show();
                    }
                    else{
                        Log.d("BT STATUS", "Fail");
                        Toast.makeText(context, "No se pudo conectar a "+  mmDevice.getName(), Toast.LENGTH_SHORT).show();
                    }

                }
            }
        };

        new Thread() {
            @SuppressLint("MissingPermission")
            @Override
            public void run() {
                boolean fail = false;

                //BluetoothDevice device = mBTAdapter.getRemoteDevice(mmDevice.getAddress());
                try {
                    mBTSocket = BluetoothUtils.createBluetoothSocket(mmDevice);
                } catch (IOException e) {
                    fail = true;
                    Toast.makeText(context, "ERROR SOCKET", Toast.LENGTH_SHORT).show();
                }
                // Establish the Bluetooth socket connection.
                try {
                    mBTSocket.connect();

                } catch (IOException e) {
                    try {
                        fail = true;
                        mBTSocket.close();
                        mHandler.obtainMessage(3, -1, -1)
                                .sendToTarget();
                    } catch (IOException e2) {
                        //insert code to deal with this
                        Toast.makeText(context, "ERROR CHECK THREAD", Toast.LENGTH_SHORT).show();
                    }
                }
                if(!fail) {
                    mConnectedThread = new ConnectedThread(mBTSocket, mHandler, context);
                    mConnectedThread.start();

                    mHandler.obtainMessage(3, 1, -1, mmDevice.getName()).sendToTarget();
                }
            }
        }.start();
    }

    public static void closeThread() {

        if(mConnectedThread != null){
            mConnectedThread.cancel();
        }
    }

    /*@SuppressLint("MissingPermission")
    public static boolean isConnected(){
       //return mBTSocket.isConnected();
        return mBTAdapter!= null && mBTAdapter.isEnabled()
                && mBTAdapter.getProfileConnectionState(BluetoothHeadset.HEADSET) == BluetoothHeadset.STATE_CONNECTED;
    }*/

    public static boolean isConnected() {
        try {
            Method m = mmDevice.getClass().getMethod("isConnected", (Class[]) null);
            boolean connected = (boolean) m.invoke(mmDevice, (Object[]) null);
            return connected;
        } catch (Exception e) {
            throw new IllegalStateException(e);
        }
    }

    @SuppressLint("MissingPermission")
    public static void bluetoothOff(){
        mBTAdapter.disable(); // turn off
        Toast.makeText(context,"Se apago Bluetooth", Toast.LENGTH_SHORT).show();
    }

    public static void printPhoto(int img) {
        try {
            Bitmap bmp = BitmapFactory.decodeResource(context.getResources(), img);
            if(bmp!=null){
                byte[] command = Utils.decodeBitmap(bmp);

                Log.d("command", "printPhoto: " + Arrays.toString(command));

                mConnectedThread.mmOutStream.write(PrinterCommands.ESC_ALIGN_CENTER);
                mConnectedThread.mmOutStream.write(command);

            }else{
                Log.e("Print Photo error", "the file isn't exists");
            }
        } catch (Exception e) {
            e.printStackTrace();
            Log.e("EXE", e.toString());
            Log.e("PrintTools", "the file isn't exists");
        }
    }

    public static void printText(Pago pago, String folio, String recibido, String pago_multa, String concepto, String fecha, String recibido_con_letra){
        try {
            /*String fechaConvert = fecha.split("-")[2] + "/" + fecha.split("-")[1] + "/"
                    + fecha.split("-")[0];*/

            String fechaConvert = new SimpleDateFormat("dd/MM/yyyy HH:mm:SS", Locale.getDefault()).format(new Date());

            String text = "--------------------------\n";
            text += "Folio: "+ folio+"\n";
            text += "Impresión: "+fechaConvert+"\n";
            text += "Ruta: "+pago.getNombre_ruta()+"\n";
            text += "Poblacion: "+pago.getNombre_poblacion()+"\n";
            text += "Recibi de: "+pago.getNombre_completo()+"\n";
            text += "Cantidad: $"+recibido + "\n";
            text += "("+recibido_con_letra + "PESOS 00/100 MN)"+ "\n";
            text += "Debe: $"+ (Utils.convertirDouble(pago.getBalance()) - Utils.convertirDouble(recibido)) + "\n";
            if(pago_multa != "0.0") text += "Multa: $"+ pago_multa + "\n";
            text += "Concepto: "+concepto+"\n";
            text += "--------------------------\n";
            mConnectedThread.write(text);

        }catch(Exception e){
            e.printStackTrace();
        }
    }

    @SuppressLint("MissingPermission")
    public static void printText(Prestamo pago, String folio, String recibido, String pago_multa, String concepto, String fecha, String recibido_con_letra){
        try {
            /*String fechaConvert = fecha.split("-")[2] + "/" + fecha.split("-")[1] + "/"
                    + fecha.split("-")[0];*/

            if(isConnected()){
                String fechaConvert = new SimpleDateFormat("dd/MM/yyyy HH:mm:SS", Locale.getDefault()).format(new Date());

                String text = "--------------------------\n";
                text += "Folio: "+ folio+"\n";
                text += fechaConvert+"\n";
                text += "Ruta: "+pago.getNombre_ruta()+"\n";
                text += "Poblacion: "+pago.getNombre_poblacion()+"\n";
                text += "Recibi de: "+pago.getNombre_completo()+"\n";
                text += "Cantidad: $"+recibido + "\n";
                text += "("+recibido_con_letra + "PESOS 00/100 MN)"+ "\n";
                //text += "Debe: $"+ (Double.parseDouble(pago.getBalance()) - Double.parseDouble(recibido)) + "\n";
                if(pago_multa != "0.0") text += "Multa: $"+ pago_multa + "\n";
                text += "Concepto: "+concepto+"\n";
                text += "--------------------------\n";
                mConnectedThread.write(text);
            }
            else{
                Toast.makeText(context, "No se pudo conectar a " +  mmDevice.getName(), Toast.LENGTH_SHORT).show();
            }

        }catch(Exception e){
            e.printStackTrace();
        }
    }
    @SuppressLint("MissingPermission")
    @RequiresApi(api = Build.VERSION_CODES.N)
    public static void printText(String titulo_ticket, String ruta_ticket, String Poblacion_ticket, String Nombre_ticket, String Atraso_ticket, String pago_ticket, String aviso,String aviso2, String empleado_ticket, String colocadora_ticket, String aval_ticket, String recargos_ticket, String monto_tot_ticket){
        try {
            String fechaConvert = new SimpleDateFormat("dd/MM/yyyy HH:mm:SS", Locale.getDefault()).format(new Date());

            String text = "--------------------------\n";
            text += titulo_ticket+"\n";
            text += fechaConvert+"\n";

            text += ruta_ticket+"\n";
            text += Poblacion_ticket +"\n";
            text += colocadora_ticket +"\n";
            text += Nombre_ticket +"\n";
            text += aval_ticket +"\n";
            text += pago_ticket+ "\n";
            text += Atraso_ticket + "\n";
            text += recargos_ticket+ "\n";
            text += monto_tot_ticket+ "\n";
            text += aviso+"\n";
            text += empleado_ticket+"\n";
            text += aviso2+"\n";
            text += "--------------------------\n";
            mConnectedThread.write(text);
        }catch(Exception e){
            e.printStackTrace();
        }
    }
    @RequiresApi(api = Build.VERSION_CODES.O)
    @SuppressLint("MissingPermission")
    public static  void printReimpresion(ReporteGeneral rg) throws ParseException {

        if(isConnected()){

            SimpleDateFormat inputFormat = new SimpleDateFormat("yyyy-MM-dd");
            SimpleDateFormat outputFormat = new SimpleDateFormat("dd/MM/yyyy");
            Date date = inputFormat.parse(rg.getFecha_pago_realizada());
            String fechaConvert = outputFormat.format(date);

            NumeroLetras numeroLetras = new NumeroLetras();

            String recibido_con_letra = numeroLetras.Convertir(rg.getPago(),
                    "", "", "",
                    "", "", true);

            String text = "--------------------------\n";
            text += "Folio: "+ (rg.getFolio() == null ? "": rg.getFolio())+"\n";
            text += "Reimpresion: " + fechaConvert+"\n";
            text += "Ruta: "+rg.getNombre_ruta()+"\n";
            text += "Poblacion: "+rg.getNombre_poblacion()+"\n";
            text += "Recibi de: "+rg.getNombre_completo()+"\n";
            text += "Cantidad: $"+rg.getPago() + "\n";
            text += "("+recibido_con_letra + "PESOS 00/100 MN)"+ "\n";
            //text += "Debe: $"+ (Double.parseDouble(pago.getBalance()) - Double.parseDouble(recibido)) + "\n";
            if(rg.getPago_multa() != "0.00") text += "Multa: $"+ rg.getPago_multa() + "\n";
            text += "Concepto: "+ (rg.getConcepto() == null ? "" : rg.getConcepto())+"\n";
            text += "--------------------------\n";
            mConnectedThread.write(text);

            Log.d("REIMRPRESION", text);

        }
        else{
            Toast.makeText(context, "No se pudo conectar a " +  mmDevice.getName(), Toast.LENGTH_SHORT).show();
        }
    }

    @RequiresApi(api = Build.VERSION_CODES.O)
    @SuppressLint("MissingPermission")
    public static void printReimpresion(Folio folio, String ruta, String poblacion, String cliente, Bitmap fa, Bitmap fc) throws ParseException, IOException {

        cliente = cliente.replace("á", "a").replace("é", "e").replace("í", "i").replace("ó", "o").replace("ú", "u").replace("ñ", "n").replace("Á", "A").replace("É", "E").replace("Í", "I").replace("Ó", "O").replace("Ú", "U").replace("Ñ", "N").replace("ü", "u").replace("Ü", "U");
        String concepto = folio.getConcepto().replace("á", "a").replace("é", "e").replace("í", "i").replace("ó", "o").replace("ú", "u").replace("ñ", "n").replace("Á", "A").replace("É", "E").replace("Í", "I").replace("Ó", "O").replace("Ú", "U").replace("Ñ", "N").replace("ü", "u").replace("Ü", "U");

        if(isConnected()) {
            String text = "--------------------------\n";
            text += "PRESTAMO GRUSEF S.A. de C.V.\n";
            text += "Folio: " + folio.getId() + "\n";
            text += "Fecha: " + folio.getFecha() + "\n";
            text += "Ruta: " + ruta + "\n";
            text += "Poblacion: \n" + poblacion + "\n";
            text += "Recibi de:\n" + cliente + "\n";
            text += "Cantidad: $" + folio.getMonto() + "\n";
            text += folio.getMonto_letra();
            text += "\nConcepto: \n";
            text += concepto;

            mConnectedThread.write(text);

            mConnectedThread.write("\nFirma del administrador: \n");

            Log.d("firmas", fa.toString());
            printBitmap(fa);

            mConnectedThread.write("Firma de la colocadora: \n");

            Log.d("firmas", fc.toString());
            printBitmap(fc);

            mConnectedThread.write("--------------------------\n\n");
        }
        else{
            Toast.makeText(context, "No se pudo conectar a " +  mmDevice.getName(), Toast.LENGTH_SHORT).show();
        }
    }

    @RequiresApi(api = Build.VERSION_CODES.O)
    @SuppressLint("MissingPermission")
    public static void imprimirRMD(RMD rmd) throws ParseException, IOException {
        String folio = rmd.getId();
        String noCuenta = rmd.getNumeroCuenta();
        String nombre = rmd.getNombre();
        String telefono = rmd.getTelefono();
        String ruta = rmd.getRuta();
        String poblacion = rmd.getPoblacion();
        String fecha = rmd.getFecha();
        ArrayList<Articulo> articulos = rmd.getArticulos();
        String valorGarantia = rmd.getValorGarantia();
        String pagara = rmd.getPagara();
        String fechaIns = rmd.getFechaIns();
        String recibeMercancia = rmd.getRecibeMercancia();
        String firmaCliente = rmd.getFirmaCliente();
        String firmaAsesor = rmd.getFirmaAsesor();

        nombre = nombre.replace("á", "a").replace("é", "e").replace("í", "i").replace("ó", "o").replace("ú", "u").replace("ñ", "n").replace("Á", "A").replace("É", "E").replace("Í", "I").replace("Ó", "O").replace("Ú", "U").replace("Ñ", "N").replace("ü", "u").replace("Ü", "U");
        recibeMercancia = recibeMercancia.replace("á", "a").replace("é", "e").replace("í", "i").replace("ó", "o").replace("ú", "u").replace("ñ", "n").replace("Á", "A").replace("É", "E").replace("Í", "I").replace("Ó", "O").replace("Ú", "U").replace("Ñ", "N").replace("ü", "u").replace("Ü", "U");

        if (isConnected()) {
            StringBuilder text = new StringBuilder("--------------------------\n");
            text.append("PRESTAMO GRUSEF S.A. de C.V.\n");
            text.append("Folio: ").append(folio).append("\n");
            text.append("Fecha: ").append(fecha).append("\n");
            text.append("No. Cuenta: ").append(noCuenta).append("\n");
            text.append("Nombre: ").append(nombre).append("\n");
            text.append("Telefono: ").append(telefono).append("\n");
            text.append("Ruta: ").append(ruta).append("\n");
            text.append("Poblacion:\n").append(poblacion).append("\n\n");
            text.append("Debido a que de inmediano no me\npuedo poner al corriente en los\npagos que me obligue a hacer en\nmi cuenta conforme al contrato\nfirmado que celebre con ustedes,\nhago entrega de las siguientes\ngarantias:\n\n");

            int i = 1;
            for (Articulo articulo : articulos) {
                String nombreArticulo = articulo.getArticulo();
                String marca = articulo.getMarca();
                String color = articulo.getColor();
                String condiciones = articulo.getDetalleCondiciones();

                nombreArticulo = nombreArticulo.replace("á", "a").replace("é", "e").replace("í", "i").replace("ó", "o").replace("ú", "u").replace("ñ", "n").replace("Á", "A").replace("É", "E").replace("Í", "I").replace("Ó", "O").replace("Ú", "U").replace("Ñ", "N").replace("ü", "u").replace("Ü", "U");
                marca = marca.replace("á", "a").replace("é", "e").replace("í", "i").replace("ó", "o").replace("ú", "u").replace("ñ", "n").replace("Á", "A").replace("É", "E").replace("Í", "I").replace("Ó", "O").replace("Ú", "U").replace("Ñ", "N").replace("ü", "u").replace("Ü", "U");
                color = color.replace("á", "a").replace("é", "e").replace("í", "i").replace("ó", "o").replace("ú", "u").replace("ñ", "n").replace("Á", "A").replace("É", "E").replace("Í", "I").replace("Ó", "O").replace("Ú", "U").replace("Ñ", "N").replace("ü", "u").replace("Ü", "U");
                condiciones = condiciones.replace("á", "a").replace("é", "e").replace("í", "i").replace("ó", "o").replace("ú", "u").replace("ñ", "n").replace("Á", "A").replace("É", "E").replace("Í", "I").replace("Ó", "O").replace("Ú", "U").replace("Ñ", "N").replace("ü", "u").replace("Ü", "U");

                nombreArticulo = configurar32Caracteres(nombreArticulo, "Nombre");
                marca = configurar32Caracteres(marca, "Marca");
                color = configurar32Caracteres(color, "Color");
                condiciones = configurar32Caracteres(condiciones, "");

                text.append("Articulo ").append(i).append("\n");
                text.append("Nombre: ").append(nombreArticulo).append("\n");
                text.append("Marca: ").append(marca).append("\n");
                text.append("Color: ").append(color).append("\n");
                text.append("Condiciones:\n").append(condiciones).append("\n\n");
                i++;
            }
            text.append("Valor garantia: $").append(valorGarantia).append("\n");
            text.append("Pagara: $").append(pagara).append("\n");
            text.append("Fecha: ").append(fechaIns).append("\n");
            text.append("Recibe mercancia:\n").append(recibeMercancia).append("\n\n");
            text.append("Y LIQUIDARA EL ADEUDO EN LAS\nPROXIMAS 24 HORAS. DE INCUMPLIR\nCON DICHO ACUERDO ACEPTO QUE MIS\nGARANTIAS SEAN VENDIDAS PARA\nCUBRIR EL IMPORTE MENCIONADO EN\nEL VALOR DE GARANTIA.\n\n");

            mConnectedThread.write(text.toString());

            Bitmap bmFirmaCliente = base64ToBitmap(firmaCliente);
            Bitmap bmFirmaAsesor = base64ToBitmap(firmaAsesor);

            mConnectedThread.write("Firma del cliente:\n");
            printBitmap(bmFirmaCliente);

            mConnectedThread.write("Firma del asesor:\n");
            printBitmap(bmFirmaAsesor);

            mConnectedThread.write("--------------------------\n\n");
        }
    }

    private static String configurar32Caracteres(String texto, String x) {
        String[] palabras = texto.split(" ");
        StringBuilder resultado = new StringBuilder();
        int countLinea = 0;
        if (Objects.equals(x, "Nombre")) countLinea = 8;
        if (Objects.equals(x, "Marca")) countLinea = 7;
        if (Objects.equals(x, "Color")) countLinea = 7;
        for (String palabra : palabras) {
            countLinea += palabra.length() + 1;
            Log.d("32chars", countLinea + " " + palabra);
            if (countLinea > 32) {
                resultado.append("\n");
                countLinea = 0;
            }
            resultado.append(palabra).append(" ");
        }
        return resultado.toString().trim();
    }

    private static Bitmap base64ToBitmap(String base64) {
        byte[] decodedBytes = Base64.decode(base64, Base64.DEFAULT);
        return BitmapFactory.decodeByteArray(decodedBytes, 0, decodedBytes.length);
    }

    private static final int MAX_WIDTH = 576;
    private static final int MAX_HEIGHT = 300;

    public static Bitmap scaleAndConvertToBW(Bitmap original) {
        int originalWidth = original.getWidth();
        int originalHeight = original.getHeight();

        // Calcular el nuevo ancho y alto escalado
        int targetWidth = Math.min(originalWidth, MAX_WIDTH);
        int targetHeight = Math.min(originalHeight, MAX_HEIGHT);

        // Si el aspecto de la imagen original no se corresponde con el tamaño máximo, ajustarlo
        float aspectRatio = (float) originalWidth / originalHeight;
        if (originalWidth > originalHeight) {
            targetHeight = (int) (targetWidth / aspectRatio);
        } else {
            targetWidth = (int) (targetHeight * aspectRatio);
        }

        // Escalar la imagen
        Bitmap scaledBitmap = Bitmap.createScaledBitmap(original, targetWidth, targetHeight, true);

        // Convertir a blanco y negro
        return convertToBlackWhite(scaledBitmap);
    }


    public static Bitmap convertToBlackWhite(Bitmap original) {
        int width = original.getWidth();
        int height = original.getHeight();
        Bitmap bwBitmap = Bitmap.createBitmap(width, height, Bitmap.Config.ARGB_8888);

        for (int y = 0; y < height; y++) {
            for (int x = 0; x < width; x++) {
                int pixel = original.getPixel(x, y);
                int gray = (Color.red(pixel) + Color.green(pixel) + Color.blue(pixel)) / 3;
                int bw = gray < 128 ? Color.BLACK : Color.WHITE;
                bwBitmap.setPixel(x, y, bw);
            }
        }
        return bwBitmap;
    }

    public static void printBitmap(Bitmap bmp) {
        Log.d("height", "printBitmap: " + bmp.getHeight());
        Log.d("width", "printBitmap: " + bmp.getWidth());
        try {
            if (bmp != null) {
                Bitmap processedBitmap = scaleAndConvertToBW(bmp);
                byte[] command = Utils.decodeBitmap(processedBitmap);

                if (command == null) {
                    Log.e("PrintTools", "decodeBitmap returned null. Bitmap might be too large or incompatible.");
                    return;
                }

                mConnectedThread.mmOutStream.write(PrinterCommands.ESC_ALIGN_CENTER);
                mConnectedThread.mmOutStream.write(command);
            } else {
                Log.e("PrintTools", "Bitmap is null");
            }
        } catch (Exception e) {
            e.printStackTrace();
            Log.e("PrintTools", "Error printing bitmap: " + e.getMessage());
        }
    }







    @SuppressLint("MissingPermission")
    @RequiresApi(api = Build.VERSION_CODES.N)
    public static void printReporteGeneral(ArrayList<ReporteGeneral> reporteGeneral, String fecha){
        try {
            sesion = context.getSharedPreferences("sesion", Context.MODE_PRIVATE);

            if(isConnected()) {
                String text = "\nREPORTE GENERAL " + fecha + "\n\n";
                text += sesion.getString("nombre", "") +"\n\n";

                double total = 0;
                for (ReporteGeneral rg : reporteGeneral) {
                    total += Utils.convertirDouble(rg.getPago());
                }
                text += "TOTAL: $" + total + "\n\n";

                Map<String, List<ReporteGeneral>> reporteGeneralGroup =
                        reporteGeneral.stream().collect(Collectors.groupingBy(w -> w.getNombre_poblacion()));

                for (Map.Entry<String, List<ReporteGeneral>> entry : reporteGeneralGroup.entrySet()) {
                    String key = entry.getKey();
                    List<ReporteGeneral> value = entry.getValue();

                    text += key + "\n";


                    for (int i = 0; i < value.size(); i++) {

                        text += value.get(i).getNombre_completo() + ": $" + value.get(i).getPago() + " ";
                        text += (value.get(i).getFolio() == null ? "":value.get(i).getFolio()) + " " + (value.get(i).getConcepto() == null ? "" : value.get(i).getConcepto()) + "\n\n";
                    }

                }

                Log.d("REPORTE", text);

                mConnectedThread.write(text);
            }
            else{
                Toast.makeText(context, "No se pudo conectar a " +  mmDevice.getName(), Toast.LENGTH_SHORT).show();
            }

        }catch(Exception e){
            e.printStackTrace();
        }

    }

    @SuppressLint("MissingPermission")
    public static void broadcastReceiver(){
        BTReceiver = new BroadcastReceiver() {
            @Override
            public void onReceive(Context context, Intent intent) {
                String action = intent.getAction();
                if(BluetoothDevice.ACTION_FOUND.equals(action)){
                    BluetoothDevice device = intent.getParcelableExtra(BluetoothDevice.EXTRA_DEVICE);
                    // add the name to the list
                    mBTArrayAdapter.add(mmDevice.getName() + "\n" + mmDevice.getAddress());
                    mBTArrayAdapter.notifyDataSetChanged();
                }
            }
        };
    }

    /*@SuppressLint("MissingPermission")
    private static void bluetoothOn(){
        if (!mBTAdapter.isEnabled()) {
            Intent enableBtIntent = new Intent(BluetoothAdapter.ACTION_REQUEST_ENABLE);
            startActivityForResult(enableBtIntent, REQUEST_ENABLE_BT);
            mBluetoothStatus.setText(getString(R.string.BTEnable));
            Toast.makeText(getApplicationContext(),getString(R.string.sBTturON),Toast.LENGTH_SHORT).show();

        }
        else{
            Toast.makeText(getApplicationContext(),getString(R.string.BTisON), Toast.LENGTH_SHORT).show();
        }
    }*/

}
